/*******************************************************************
 *
 *	File:		Stdlib.cpp
 *
 *	Author:		Peter van Sebille (peter@yipton.demon.co.uk)
 *
 *	(c) Copyright 2001, Peter van Sebille
 *	All Rights Reserved
 *
 *******************************************************************/

extern "C" {
#include "driver.h"
}

#include <signal.h>
#include <e32std.h>

#include "emame.h"



void Oops()
{
	EMAME_DEBUGGER_ALWAYS();

	User::InfoPrint(_L("Oops, the MAME Engine raised an excpetion, EMame will terminate"));
	User::After(1000 * 1000 * 3);

		/*
		 * On target we really want to kill off the entire process. This has the
		 * unfortunate side effect in WINS to kill off the emulator (because there is
		 * only one process).
		 */
	RProcess	me;
	me.Terminate(KErrGeneral);
}


int eraise(int)
{
	Oops();
	return 0;		// never reached
}

#undef raise

int raise(int)
{
	Oops();
	return 0;		// never reached
}

void exit(int aExitCode)
{
	DEBUGGER();

	if (aExitCode != 0)
	{
		User::InfoPrint(_L("The MAME Engine exited, EMame will terminate"));
		User::After(1000 * 1000 * 3);

		RProcess	me;
		me.Terminate(KErrNone);
	}
}

