/******************************************************************************

  driver.c

  The list of all available drivers. Drivers have to be included here to be
  recognized by the executable.

  To save some typing, we use a hack here. This file is recursively #included
  twice, with different definitions of the DRIVER() macro. The first one
  declares external references to the drivers; the second one builds an array
  storing all the drivers.

  ORIGINAL MAME SOURCE CODE
  Slightly modified for EMame

******************************************************************************/

#include "driver.h"
#include "emame.h"


/* The "root" driver, defined so we can have &driver_##NAME in macros. */
struct GameDriver driver_0 =
{
	__FILE__,
	0,
	"",
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	NOT_A_DRIVER
};

#define TESTDRIVER(x)

#define DRIVER(NAME) extern struct GameDriver driver_##NAME;
#ifdef __FULL_DRIVER_LIST__
#include "fulldriverlist.h"
#else
#include "driverlist.h"
#endif

#undef DRIVER
#define DRIVER(NAME) &driver_##NAME,

const struct GameDriver *drivers[] =
{
#ifdef __FULL_DRIVER_LIST__
#include "fulldriverlist.h"
#else
#include "driverlist.h"
#endif
	0	/* end of array */
};


