/*******************************************************************
 *
 *	File:		GlobalData.h
 *
 *	Author:		Peter van Sebille (peter@yipton.demon.co.uk)
 *
 *	(c) Copyright 2001, Peter van Sebille
 *	All Rights Reserved
 *
 *******************************************************************/

#ifndef __GLOBALDATA__H
#define __GLOBALDATA__H

#include <w32std.h>		// for EEventUser

#include "driver.h"


class TGameOptions
{
public:
	enum TOrientation
	{
		EOrientationNone = 0,
		EOrientationLeft,
		EOrientationRight,
		EOrientationUpsideDown
	};

	enum TContrast
	{
		EContrastNone = 0,
		EContrastSetToLow
	};

	enum TGameSize
	{
		EGameSizeNormal = 0,
		EGameSizeFitScreen
	};

	TOrientation	iOrientation;
	TContrast		iContrast;
	TGameSize		iGameSize;
	TBool			iSoundEnabled;
};



/*
 * ON TARGET
 *
 * The mame emulator is a console app (emame.exe) which starts an EPOC App (emameapp.app)
 * in its thread. Before the emulator starts the App, it will create a global chunk 
 * called KGlobalDataChunkName and writes a single DWORD in it.
 * The DWORD is a pointer to a TGlobalData structure. 
 *
 * ON WINS
 *
 * We start the EPOC App first as per normal. The App will dynamically load the 
 * emulator (emame.dll). The App calls Emame.dll' one and only exported function: 
 * InitEmulator. From InitEmulator the global chunk is created and initialsed.
 * After that the App can open the chunk as well. 
 *
 */

enum
{
	EMameShuttingDown = EEventUser + 1
};

typedef	void (*TShutdownFunc)();
typedef void (*TRunGameFunc)(TInt aGame, const TGameOptions& aGameOptions);
typedef	const char* (*TCpunumNameFunc)(int aCpu);

class TGlobalData
{
public:
	// Pssed in from EMame --> EMameApp
	struct GameDriver**	iGameDrivers;
	TRunGameFunc		iRunGameFunc;
	TCpunumNameFunc		iCpunumNameFunc;
	TShutdownFunc		iShutdownFunc;


	// Passed in from EMameApp --> EMame
	TInt				iAppWindowGroupId;
	TBool				iForcedExitFromFrontEnd;
};


#define KGlobalDataChunkName	_L("EMAME_GLOBAL")

TGlobalData& GlobalData();
const TGameOptions& GameOptions();


#endif			/* __GLOBALDATA__H */