/*******************************************************************
 *
 *	File:		Audio.h
 *
 *	Author:		Peter van Sebille (peter@yipton.demon.co.uk)
 *
 *	(c) Copyright 2001, Peter van Sebille
 *	All Rights Reserved
 *
 *******************************************************************/

#ifndef __AUDIO_H
#define __AUDIO_H


#include <e32base.h>
#include <w32std.h>
#ifdef __ER6__
#include "er6_d32snd.h"
#else
#include <d32snd.h>
#endif



#define	MAX_SOUND_BUFFER 0x8000

class CMameAudio : CBase
{
public:
	static CMameAudio* NewL(TBool aStereo, TInt aSamplesPerFrame);
	~CMameAudio();
	void Destruct();
	void SoundUpdate();
	TInt ProcessSoundSamples(TInt16* aBuffer);
	TInt FirstNoOfSamples();

protected:
	CMameAudio(TBool aStereo, TInt aSamplesPerFrame);
	void ConstructL();

	RDevSound		iDevSound;
	TRequestStatus	iStatus;

	TUint8			iAlawSoundBuffer[MAX_SOUND_BUFFER];
	TInt			iSamplesPerFrame;

	TBool			iStereo;

	TInt			iFrameCount;
	TInt			iTotalFrameCount;
};


#endif			/* __AUDIO_H */
