// D32SND.H
//
// Copyright (c) 1995-1999 Symbian Ltd.  All rights reserved.
//

#if !defined(__D32SND_H__)
#define __D32SND_H__
#if !defined(__E32STD_H__)
#include <e32std.h>
#endif
#if !defined(__E32VER_H__)
#include <e32ver.h>
#endif

const TInt KAlawSamplesPerSecond=8000;
const TInt KAlawSilence=0x55;
const TInt KMaxSineWaveVolume=100;

enum TSoundVolume {EVolumeNone,EVolumeSoft,EVolumeMedium,EVolumeLoud,EVolumeByValue};

class TSoundConfigV01
    {
public:
	TSoundVolume iVolume;
	TInt iVolumeValue;
	TTimeIntervalMicroSeconds32 iDtmfToneOnLength;
	TTimeIntervalMicroSeconds32 iDtmfToneOffLength;
	TTimeIntervalMicroSeconds32 iDtmfPauseLength;
	TInt iAlawBufferSize;
	};
typedef TPckgBuf<TSoundConfigV01> TSoundConfig;
//
const TUint KCapsVolumeNone=0x00000001;
const TUint KCapsVolumeSoft=0x00000002;
const TUint KCapsVolumeMedium=0x00000004;
const TUint KCapsVolumeLoud=0x00000008;
const TUint KCapsVolumeByValue=0x00000010;
//
const TUint KCapsDtmfAvailable=0x00000001;
const TUint KCapsFallBackAlarmSoundAvailable=0x00000002;
const TUint KCapsPlayAlawDataAvailable=0x00000004;
const TUint KCapsRecordAlawDataAvailable=0x00000008;
const TUint KCapsSimultaneousPlayAndRecordAvailable=0x00000010;
//
class TSoundCapsV01
	{
public:
	TUint iService;
	TUint iVolume;
	TInt iMaxVolume;
	TInt iMaxFrequency;
	};
typedef TPckgBuf<TSoundCapsV01> TSoundCaps;
//
class TCapsDevSoundV01
	{
public:
	TVersion version;
	};

class TSineInfo
	{
public:
	inline TSineInfo(TInt aFrequency,TInt aVolume,TTimeIntervalMicroSeconds32 aDuration);
	TInt iFrequency;
	TInt iVolume;//0 to KMaxSineWaveVolume
	TTimeIntervalMicroSeconds32 iDuration;
	};
//
class RDevSound : public RBusLogicalChannel// RLogicalChannel
	{
public:
	enum TVer {EMajorVersionNumber=1,EMinorVersionNumber=0,EBuildVersionNumber=KE32BuildVersionNumber};
	enum TRequest
		{
		ERequestPlay=0x0,ERequestRecord=0x1,
		ERequestPlayCancel=0x1,ERequestRecordCancel=0x2
		};
	enum TControl
		{
		EControlGetAlarmSoundCount,EControlGetAlarmSoundName,
		EControlConfig,EControlSetConfig,EControlCaps,
		EControlPreparePlayAlawBuffer,EControlPrepareRecordAlawBuffer,
		EControlFlushPlayBuffer,EControlFlushRecordBuffer,
		EControlBytesPlayed,EControlResetBytesPlayed
		};
	enum TPlayType
		{
		EPlayAlawData,EPlayAlarmSound,EPlayFallBackAlarmSound,EPlayDtmf,EPlaySineWave
		};
public:
	inline TInt Open(TInt aUnit=KNullUnit);
	inline TVersion VersionRequired() const;
	inline void PlaySineWave(TRequestStatus& aStatus,TInt aFrequency,TInt aAmplitude,TTimeIntervalMicroSeconds32 aDuration);
	inline void PlayDtmf(TRequestStatus& aStatus,const TDesC& aDes);
	inline void PlayAlarmSound(TRequestStatus& aStatus,TInt aAlarm);
	inline void PlayFallBackAlarmSound(TRequestStatus& aStatus);
	inline void PlayAlawData(TRequestStatus &aStatus,const TDesC8 &aData);
	inline void FlushPlayBuffer();
	inline void PlayCancel();
	inline void RecordAlawData(TRequestStatus& aStatus,TDes8& aData);
	inline void FlushRecordBuffer();
	inline void RecordCancel();
	inline TInt AlarmSoundCount();
	inline TInt AlarmSoundName(TInt anIndex, TName& aName);
	inline void Config(TDes8 &aConfig);
	inline TInt SetConfig(const TDesC8& aConfig);
	inline void Caps(TDes8& aCaps);
	inline TInt PreparePlayAlawBuffer();
	inline TInt PrepareRecordAlawBuffer();
	inline TInt BytesPlayed();
	inline void ResetBytesPlayed();
	};
#include "er6_d32snd.inl"
#endif

