$makeexe="e:\\quartz_rc3\\epoc32\\gcc\\bin\\make.exe";

(-e $makeexe) or die "Please edit genmmp.pl and set makeexe to the location of GNU's make.exe";

unlink "genmmp.tmp";
unlink "genmmp.lst";
unlink("mameengineobjs.wins");
unlink("mameengineobjs.marm");


#########################################
#
# Get info from the makefiles
#
#########################################

exec "$makeexe -f dummy.mak dump_sounddef > genmmp.tmp";
open(GENMMPTMP, "genmmp.tmp");
$sound_defs = <GENMMPTMP>;
chop $sound_defs;

print "$sound_defs\n";

exec "$makeexe -f dummy.mak dump_cpudefs > genmmp.tmp";
open(GENMMPTMP, "genmmp.tmp");
$cpu_defs = <GENMMPTMP>;
chop $cpu_defs;

exec "$makeexe -f dummy.mak dump_soundobj > genmmp.tmp";
open(GENMMPTMP, "genmmp.tmp");
$sound_obj = <GENMMPTMP>;

exec "$makeexe -f dummy.mak dump_coreobj > genmmp.tmp";
open(GENMMPTMP, "genmmp.tmp");
$core_obj = <GENMMPTMP>;

exec "$makeexe -f dummy.mak dump_cpuobj > genmmp.tmp";
open(GENMMPTMP, "genmmp.tmp");
$cpu_obj = <GENMMPTMP>;

exec "$makeexe -f dummy.mak dump_drvlib > genmmp.tmp";
open(GENMMPTMP, "genmmp.tmp");
$drvlib = <GENMMPTMP>;

open(USERDEFS, "tmpl/userdefs");
$user_defs = <USERDEFS>;
chop $user_defs;

#################################################################
#
# We build individual libraries for CPU, MACHINE, SOUND, SNDHRDWR, 
# VIDHRDWR and core directories.
# In addition, we create a MAMECORE library that contains all these
# .0 files
#
# First build a list of all .o files. We already have a list of sound + 
# cpu + core objects.
# We now parse the makefile again to get a list of dependents
# for each of the .a libs in drvlib
#
#################################################################

$objs = $sound_obj . $cpu_obj . $core_obj;
@tmp_obj_list = split ' ',  $objs;
@lib_list = split ' ', $drvlib;

exec "$makeexe -f  dummy.mak  -p > genmmp.tmp";
foreach $lib_file (@lib_list) 
{
	$lib_file = substr $lib_file, 2;		# get rid of ./
	system "findstr /r \"^$lib_file\" genmmp.tmp >> genmmp.lst";
}

open(FILELIST, "genmmp.lst");
while ($lib_list = <FILELIST>) 
{
	@file_list = split ' ', $lib_list;
	foreach $object (@file_list) 
	{
		if ($object =~ /[.]o$/) 
		{
			push @tmp_obj_list, $object;
		}
	}
}


foreach $object (@tmp_obj_list) 
{
	if ($object =~ /[.]o$/) 
	{
		chop $object;
		$object .= "c";
		if ($object =~ /^[.]/) 
		{
			$object = substr $object, 2;
		}
		$exist = 0;
		foreach $object_already (@obj_list) 
		{
			if ($object_already eq $object) 
			{
				$exist = 1;
				LAST;
			}
		}
		if (!$exist) 
		{
			push @obj_list, $object;
		}
	}
}



system "xcopy /Y /R tmpl\\*.mmp . > nul";

open(WINSMAKEFILE, ">>mameengineobjs.wins");
open(MARMMAKEFILE, ">>mameengineobjs.marm");
print WINSMAKEFILE "LINK_OBJS= \\\n";


#################################################################
#
# Generate core.mmp
#
#################################################################

print MARMMAKEFILE "CORE_LINK_OBJS= \\\n";

open(MMPFILE, ">>core.mmp");
foreach $object (@obj_list) 
{
	if ($object =~ /[\/]/) next;

	$skip = 0;
	if ($object =~ /driver[.]c/) {$skip = 1;}
	if ($object =~ /cpuintrf[.]c/) {$skip = 1;}
	if ($object =~ /sndintrf[.]c/) {$skip = 1;}
	if ($skip == 0)
	{
		print MMPFILE "SOURCE $object\n";
		
		chop $object;
		print WINSMAKEFILE "    \\epoc32\\build\\mame\\src\\winsd\\deb\\$object" . "obj \\\n";
		print MARMMAKEFILE "    $object" . "o \\\n";
	}
}
print "Generated core.mmp\n";

#################################################################
#
# Generate drivers.mmp
#
#################################################################

print MARMMAKEFILE "\nDRIVERS_LINK_OBJS= \\\n";

open(MMPFILE, ">>drivers.mmp");
foreach $object (@obj_list) 
{
	if ($object =~ /^drivers[\/]/) 
	{
		$object = substr $object, 8;
		print MMPFILE "SOURCE $object\n";

		chop $object;
		print WINSMAKEFILE "    \\epoc32\\build\\mame\\src\\drivers\\winsd\\deb\\$object" . "obj \\\n";
		print MARMMAKEFILE "    $object" . "o \\\n";
	}
}
print "Generated drivers.mmp\n";


#################################################################
#
# Generate sound.mmp
#
#################################################################

print MARMMAKEFILE "\nSOUND_LINK_OBJS= \\\n";

open(MMPFILE, ">>sound.mmp");
foreach $object (@obj_list) 
{
	if ($object =~ /^sound[\/]/) 
	{
		$object = substr $object, 6;
		print MMPFILE "SOURCE $object\n";

		chop $object;
		print WINSMAKEFILE "    \\epoc32\\build\\mame\\src\\sound\\winsd\\deb\\$object" . "obj \\\n";
		print MARMMAKEFILE "    $object" . "o \\\n";
	}
}
print "Generated sound.mmp\n";


#################################################################
#
# Generate vidhrdw.mmp
#
#################################################################

print MARMMAKEFILE "\nVIDHRDW_LINK_OBJS= \\\n";

open(MMPFILE, ">>vidhrdw.mmp");
foreach $object (@obj_list) {
	if ($object =~ /^vidhrdw[\/]/) 
	{
		$object = substr $object, 8;
		print MMPFILE "SOURCE $object\n";

		chop $object;
		print WINSMAKEFILE "    \\epoc32\\build\\mame\\src\\vidhrdw\\winsd\\deb\\$object" . "obj \\\n";
		print MARMMAKEFILE "    $object" . "o \\\n";
	}
}
print "Generated vidhrdw.mmp\n";

#################################################################
#
# Generate machines.mmp
#
#################################################################

print MARMMAKEFILE "\nMACHINES_LINK_OBJS= \\\n";

open(MMPFILE, ">>machines.mmp");
foreach $object (@obj_list) 
{
	if ($object =~ /^machine[\/]/) 
	{
		$object = substr $object, 8;
		print MMPFILE "SOURCE $object\n";

		chop $object;
		print WINSMAKEFILE "    \\epoc32\\build\\mame\\src\\machine\\winsd\\deb\\$object" . "obj \\\n";
		print MARMMAKEFILE "    $object" . "o \\\n";
	}
}
print "Generated machines.mmp\n";


#################################################################
#
# Generate sndhrdw.mmp
#
#################################################################

print MARMMAKEFILE "\nSNDHRDW_LINK_OBJS= \\\n";

open(MMPFILE, ">>sndhrdw.mmp");
foreach $object (@obj_list) 
{
	if ($object =~ /^sndhrdw[\/]/) 
	{
		$object = substr $object, 8;
		print MMPFILE "SOURCE $object\n";

		chop $object;
		print WINSMAKEFILE "    \\epoc32\\build\\mame\\src\\sndhrdw\\winsd\\deb\\$object" . "obj \\\n";
		print MARMMAKEFILE "    $object" . "o \\\n";
	}
}
print "Generated sndhrdw.mmp\n";


#################################################################
#
# Generate cpus.mmp
#
#################################################################

print MARMMAKEFILE "\nCPUS_LINK_OBJS= \\\n";

open(MMPFILE, ">>cpus.mmp");
foreach $object (@obj_list) 
{
	if ($object =~ /^cpu[\/]/) 
	{
		push @tmp_cpu_list, substr $object, 4;
	}
}
@cpu_list = sort @tmp_cpu_list;

$last_cpu = "";
foreach $object (@cpu_list) 
{
	$pos = index $object, "\/";
	$cpu = substr $object, 0, $pos;

	if (!($cpu eq $last_cpu)) 
	{
		print MMPFILE "\n\nSUBPROJECT $cpu\n";
		print MMPFILE "USERINCLUDE \\mame\\src\\cpu\\$cpu\n";

		$last_cpu = $cpu;

		if ($cpu eq "m68000" && (! -e "/mame/src/cpu/m68000/release/m68kmake.exe")) 
		{
			chdir "/mame/src/cpu/m68000";
			system "nmake -f /mame/src/epoc/group/m68kmake.mak CFG=\"M68kmake - Win32 Release\" > m68kmake.log";
			system "release/m68kmake.exe";
			chdir "/mame/src/epoc/group";

			print "Generating m68k000 source code\n"
		}
	}

	$object = substr $object, $pos + 1;
	print MMPFILE "SOURCE $object\n";

	chop $object;
	print WINSMAKEFILE "    \\epoc32\\build\\mame\\src\\cpu\\winsd\\deb\\$object" . "obj \\\n";
	print MARMMAKEFILE "    $object" . "o \\\n";

}
print "Generated cpus.mmp\n";


#########################################
#
# Generate userdefs
#
#########################################


open(USERDEFS, ">userdefs");
$all_defines = $user_defs . " " . $cpu_defs ." " . $sound_defs;
@tmp_defines = split ' ', $all_defines;
foreach $define (@tmp_defines) 
{
	$def = $define;
	if ($def =~ /=0$/) next;
	push @defines, $define;
}
print USERDEFS join ' ', @defines;

print "Generated userdefs\n";

unlink "genmmp.tmp";
unlink "genmmp.lst";

print "\nTODO: use the correct makefiles\n"