/*******************************************************************
 *
 *	File:		EMameEngine.h
 *
 *	Author:		Peter van Sebille (peter@yipton.demon.co.uk)
 *
 *	(c) Copyright 2001, Peter van Sebille
 *	All Rights Reserved
 *
 *******************************************************************/

#ifndef __EMAME_ENGINE_H
#define __EMAME_ENGINE_H

#include <e32std.h>
#include <e32base.h>

#include "GlobalData.h"


class CMameEngine;

class MGameWatcher
{
public:
	virtual void NotifyGameFinished() = 0;
};


class CGameRunner : public CActive
{
public:
	static CGameRunner* NewL(MGameWatcher& aGameWatcher, CMameEngine& aMameEngine);
	~CGameRunner();

	void RunGameL(TInt aGame);
	void TerminateGame();

protected:
	CGameRunner(MGameWatcher& aGameWatcher, CMameEngine& aMameEngine);
	void ConstructL();

	virtual void RunL();
	virtual void DoCancel();

	void DoRunGameL();
	static TInt ThreadMameGame(TAny* aData);
	void ShutdownGame();
	
	MGameWatcher&		iGameWatcher;
	RThread				iThread;
	TInt				iGame;
	TInt				iGameCounter;
	CMameEngine&		iMameEngine;
};




class CMameEngine : public CBase
{
public:
	static CMameEngine* NewL();
	~CMameEngine();

	TGameOptions		GameOptions() {return iGameOptions;}
	void				SetGameOptions(const TGameOptions& aGameOptions){iGameOptions = aGameOptions;}
	void				SetWindowGroupId(TInt aWindowGroupId);
	void				ShutdownGame();
	struct GameDriver**	GameDrivers();
	const char*			CpuName(TInt aCpuType);
	TInt				GameNo(const TDesC& aGameName);
	const char*			GameName(TInt aGameNo);
	TBool				IsGameCloneOf(struct GameDriver* aGame);
	void				ForceGameExit();


protected:
	CMameEngine();
	void ConstructL();

	friend class CGameRunner;
	void RunGameL(TInt aGame);
	void KillRunningStdoutConsole();

//	TInt			iGame;
//	TInt			iGameCounter;

	TGameOptions	iGameOptions;

	RChunk			iGlobalDataChunk;
	TGlobalData*	iGlobalData;

#ifdef __WINS__
	RLibrary	iMameLib;
#endif
};


#endif			/* __EMAME_ENGINE_H */
