/*******************************************************************
 *
 *	File:		EMameApp.h
 *
 *	Author:		Peter van Sebille (peter@yipton.demon.co.uk)
 *
 *	(c) Copyright 2001, Peter van Sebille
 *	All Rights Reserved
 *
 *******************************************************************/

#ifndef __EMAME_APP_H
#define __EMAME_APP_H

#include <coecntrl.h>
#include <coeccntx.h>
#include <coemain.h>

#include <eikappui.h>
#include <eikapp.h>
#include <eikdoc.h>

#ifndef __ER6__
#include <eikcmds.hrh>
#endif


#include "emameapp.hrh"

#include "EmameEngine.h"


const TUid KUidEmameApp = { 0x10009BB3 };


class CWsBitmap;

class CMameDocument : public CEikDocument
{
public:
	~CMameDocument();
	CMameDocument(CEikApplication& aApp);
	void ConstructL();

	CMameEngine&	MameEngine(){return *iMameEngine;}

protected:
	CMameEngine*	iMameEngine;

private: // from CEikDocument
	CEikAppUi* CreateAppUiL();
};


class CMameAppView : public CCoeControl, public MCoeControlBrushContext
{
public:
	~CMameAppView();
	void ConstructL(const TRect& aRect);
private:
	void Draw(const TRect& /*aRect*/) const;

	CWsBitmap*	iBgImage;
	TPoint		iImagePosition;
};



class CMameAppUi : public CEikAppUi, MGameWatcher
{
public:
	CMameAppUi() : iGameToRun(-1){}
	void ConstructL();
	~CMameAppUi();

	TBool CMameAppUi::IsColorDevice();

		// cannot be called during construction of the document!
	static CMameAppUi*	Static() {return (CMameAppUi*) CEikonEnv::Static()->AppUi();}

protected: // from CEikAppUi
	virtual void HandleApplicationSpecificEventL(TInt aType,const TWsEvent& aEvent);

	void SetDefaultGameOptions(TBool aIsColorDevice);
	void HandleCommandL(TInt aCommand);
	void DisplayGamePlayDialogL();
	void DisplayGameOptionsDialogL();
	void DisplayHelpDialogL();
	void DisplayAboutDialogL();

	CMameEngine& MameEngine(){return ((CMameDocument*) Document())->MameEngine();}
	CGameRunner*	iGameRunner;
	CEikDialog*		iGameRunningDialog;

	void StartGameL(TInt aGame);
	void StopGame();

protected:
	virtual void NotifyGameFinished();

protected:
	TInt		iGameToRun;

	void RunGameL();

private:
	CMameAppView* iAppView;
};






class CMameApplication : public CEikApplication
	{
private: // from CApaApplication
	CApaDocument* CreateDocumentL();
	TUid AppDllUid() const;
	};

#endif
