-- Move all windows on a WIonWS to a single frame and destroy the rest.

collapse={}

function collapse.move_managed(tgt, src)
    local l=src:managed_list()
    for _, m in l do
        tgt:attach(m)
    end
end

function collapse.collapse(ws)
    local l=ws:managed_list()
    -- Move everything to current frame if set,
    -- otherwise the first one found.
    local tgt=ws:current()
    for _, f in l do
        if obj_is(f, "WIonFrame") then
            if not tgt then
                tgt=f
            else
                collapse.move_managed(tgt, f)
                f:close()
            end
        end
    end
end

-- Simpler, but moves the windows around 
-- more, which doesn't look good.
function collapse.collapse2(ws)
    local l=ws:managed_list()
    local prevf
    for _, f in l do
        if obj_is(f, "WIonFrame") then
            if prevf then
                prevf:relocate_and_close()
            end
            prevf=f
        end
    end
end

